/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.rbf.RbfErrorDetail;
import com.ibm.hwmca.fw.rbf.RbfException;
import com.ibm.hwmca.fw.rbf.RbfHandleResponse;
import com.ibm.hwmca.fw.rbf.RbfRequest;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.CompleteReply;
import com.ibm.hwmca.fw.rbf.impl.HandlerPreparer;
import com.ibm.hwmca.fw.rbf.impl.RbfMsg;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.rbf.impl.RbfUtils;
import com.ibm.hwmca.fw.rbf.impl.RequestHandlingManager;
import com.ibm.hwmca.fw.rbf.impl.RequestManager;
import com.ibm.hwmca.fw.rbf.impl.RequestTrackingData;
import com.ibm.hwmca.fw.rbf.impl.ResultReporter;
import com.ibm.hwmca.fw.util.Trace;

class CompleteMsg
implements RbfMsg {
    private static final String TRACE_MASKT = "XRBFCMST";
    private static final String TRACE_MASKF = "XRBFCMSF";
    private static final String TRACE_MASKD = "XRBFCMSD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RBF-ComplMsg");
    private static final long serialVersionUID = 4799939527058349173L;
    private RbfRequestId requestId;
    private int status;
    private byte[] responseEncoding;
    private RbfErrorDetail errorDetail;
    static final int STATUS_HANDLED = 0;
    static final int STATUS_NOT_HANDLED = 4;
    static final int STATUS_HANDLER_UNAVAILABLE = 6;
    static final int STATUS_INTERNAL_ERROR = 8;
    static final int STATUS_APPLICATION_ERROR = 12;

    CompleteMsg(RbfRequest request, byte[] responseEncoding) {
        if (request == null) {
            throw new IllegalArgumentException("Null request");
        }
        if (responseEncoding == null) {
            throw new IllegalArgumentException("Null handle response encoding");
        }
        this.requestId = request.getIdentifier();
        this.status = 0;
        this.responseEncoding = responseEncoding;
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    CompleteMsg(RbfRequest request, RbfHandleResponse handleResponse) throws PersistenceException {
        if (request == null) {
            throw new IllegalArgumentException("Null request");
        }
        if (handleResponse == null) {
            throw new IllegalArgumentException("Null handle response");
        }
        this.requestId = request.getIdentifier();
        this.status = 0;
        try {
            PersistenceManager persistMgr = PersistenceManager.getPersistenceManager();
            this.responseEncoding = PersistenceManager.encode(handleResponse);
        }
        catch (PersistenceException pe) {
            String desc = pe.getClass().getName() + " encoding " + handleResponse.getClass().getName() + " " + this.requestId;
            Trace.trace(TRACE_MASKF, desc);
            FrameworkLog fl = new FrameworkLog(classLogInfo, 1056);
            fl.add(desc);
            fl.add(RbfUtils.getLoggingInfo(request));
            fl.log();
            throw pe;
        }
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    CompleteMsg(RbfRequest request, int status, RbfErrorDetail errorDetail) {
        if (request == null) {
            throw new IllegalArgumentException("Null request");
        }
        if (!this.isValidStatus(status) || status == 0) {
            throw new IllegalArgumentException("Invalid status");
        }
        if ((status == 8 || status == 12) && errorDetail == null) {
            throw new IllegalArgumentException("Null error detail");
        }
        this.requestId = request.getIdentifier();
        this.status = status;
        this.errorDetail = errorDetail;
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    boolean isValidStatus(int status) {
        switch (status) {
            case 0: {
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                return true;
            }
            case 8: {
                return true;
            }
            case 12: {
                return true;
            }
        }
        return false;
    }

    RbfRequestId getRequestId() {
        return this.requestId;
    }

    int getStatus() {
        return this.status;
    }

    RbfErrorDetail getErrorDetail() {
        return this.errorDetail;
    }

    byte[] getResponseEncoding() {
        return this.responseEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RbfReply process(MachineId sender2, int protocol) {
        RequestTrackingData trackingData;
        Trace.trace(TRACE_MASKT, "-> process()");
        RbfErrorDetail lclErrorDetail = null;
        CompleteReply reply = new CompleteReply(this.requestId);
        RbfRequest request = RbfRequest.getRequest(this.requestId);
        if (request == null) {
            Trace.trace(TRACE_MASKF, "Request no longer managed");
            Trace.trace(TRACE_MASKT, "<- process()");
            return reply;
        }
        RequestTrackingData requestTrackingData = trackingData = request.getTrackingData();
        synchronized (requestTrackingData) {
            if (trackingData.state != 4 && trackingData.state != 8) {
                Trace.trace(TRACE_MASKF, "Processing not needed due to request state");
                Trace.trace(TRACE_MASKT, "<- process()");
                return reply;
            }
            if (!this.isValidStatus(this.status)) {
                String desc = "Internal error: Invalid complete message status (" + this.status + ") received from " + RbfUtils.getMachineInfo(sender2) + this.requestId;
                Trace.trace(TRACE_MASKF, desc);
                FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                fl.add(desc);
                fl.add(RbfUtils.getLoggingInfo(request));
                fl.log();
                trackingData.removeAborting(sender2);
                trackingData.removePreparing(sender2);
                trackingData.addUnusable(sender2);
                if (sender2.equals(trackingData.handler)) {
                    trackingData.redrive = true;
                    trackingData.removeAllBusy();
                }
                if (trackingData.isHandlerNeeded()) {
                    trackingData.errorDetail = lclErrorDetail = new RbfErrorDetail(1060, desc);
                    trackingData.errorResultCode = 8;
                    HandlerPreparer.prepareHandlers(request);
                }
            } else if (this.status == 4) {
                trackingData.removeAborting(sender2);
                trackingData.removePreparing(sender2);
                if (trackingData.isHandlerNeeded()) {
                    HandlerPreparer.prepareHandlers(request);
                }
            } else if (this.status == 6) {
                trackingData.removePreparing(sender2);
                trackingData.removeAborting(sender2);
                trackingData.addUnusable(sender2);
                if (trackingData.isHandlerNeeded()) {
                    HandlerPreparer.prepareHandlers(request);
                }
            } else if (this.status == 8 || this.status == 12) {
                trackingData.removeAborting(sender2);
                trackingData.removePreparing(sender2);
                trackingData.addUnusable(sender2);
                if (this.errorDetail == null) {
                    String desc = "No error detail provided by " + RbfUtils.getMachineInfo(sender2) + " " + this.requestId;
                    this.errorDetail = new RbfErrorDetail(1060, desc);
                }
                if (sender2.equals(trackingData.handler)) {
                    trackingData.redrive = true;
                    trackingData.removeAllBusy();
                }
                if (trackingData.isHandlerNeeded()) {
                    trackingData.errorDetail = this.errorDetail;
                    trackingData.errorResultCode = this.status == 8 ? 8 : 12;
                    HandlerPreparer.prepareHandlers(request);
                }
            } else {
                trackingData.addHistory("Handled by " + RbfUtils.getMachineInfo(sender2));
                RbfHandleResponse handleResponse = null;
                if (this.responseEncoding == null) {
                    String desc = "Internal error: No response encoding provided in complete message received from " + RbfUtils.getMachineInfo(sender2) + " " + this.requestId + ":\n" + this;
                    Trace.trace(TRACE_MASKF, desc);
                    FrameworkLog fl = new FrameworkLog(classLogInfo, 1060);
                    fl.add(desc);
                    fl.add(RbfUtils.getLoggingInfo(request));
                    fl.log();
                    lclErrorDetail = new RbfErrorDetail(1060, desc);
                    this.reportAndClose(request, 8, lclErrorDetail);
                } else {
                    try {
                        PersistenceManager persistMgr = PersistenceManager.getPersistenceManager();
                        handleResponse = (RbfHandleResponse)PersistenceManager.decode(this.responseEncoding);
                        Trace.trace(TRACE_MASKF, "handleResponse=" + handleResponse);
                    }
                    catch (PersistenceException pe) {
                        String desc = pe.getClass().getName() + " decoding handler " + "response from " + RbfUtils.getMachineInfo(sender2) + " " + this.requestId + ":\n" + RbfUtils.getStackTrace(pe);
                        Trace.trace(TRACE_MASKF, desc);
                        FrameworkLog fl = new FrameworkLog(classLogInfo, 1057);
                        fl.add(desc);
                        fl.add(RbfUtils.getLoggingInfo(request));
                        fl.log();
                        lclErrorDetail = new RbfErrorDetail(1057, desc);
                        this.reportAndClose(request, 12, lclErrorDetail);
                    }
                }
                if (handleResponse != null) {
                    Object handlerDetails = handleResponse.getDetails();
                    if (!handleResponse.isValidRequest()) {
                        this.reportAndClose(request, 24, handlerDetails);
                    } else if (handleResponse.isSuccessful()) {
                        this.reportAndClose(request, 0, handlerDetails);
                    } else if (handleResponse.isRedrivable()) {
                        try {
                            RequestHandlingManager rhMgr = RequestHandlingManager.getRequestHandlingManager();
                            rhMgr.storeHandleResponse(handleResponse);
                        }
                        catch (RbfException rbfe) {
                            // empty catch block
                        }
                        trackingData.redrive = true;
                        trackingData.addUnusable(sender2);
                        trackingData.removeAllBusy();
                        try {
                            RequestManager requestMgr = RequestManager.getRequestManager();
                            requestMgr.changed(request);
                        }
                        catch (RbfException rbfe) {
                            // empty catch block
                        }
                        Trace.trace(TRACE_MASKF, "Redriving " + this.requestId);
                        trackingData.addHistory("Redriving");
                        HandlerPreparer.prepareHandlers(request);
                    } else {
                        this.reportAndClose(request, 28, handlerDetails);
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- process()");
        return reply;
    }

    private void reportAndClose(RbfRequest request, int statusCode, Object details) {
        ResultReporter.reportAndClose(request, statusCode, details);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[CompleteMsg: reqId=" + this.requestId + ", status=" + this.status);
        if (this.responseEncoding != null) {
            sb.append(", responseEncoding=yes");
        } else {
            sb.append(", responseEncoding=null");
        }
        if (this.errorDetail != null) {
            sb.append(", errorDetail=yes");
        } else {
            sb.append(", errorDetail=null");
        }
        sb.append("]");
        return sb.toString();
    }
}

